#!/bin/csh
#
# cleantex - clean up files related to Latex processing
#
# usage - cleantex [base]...
# default is \*, ie, to remove all latex extraneous files. 
# Otherwise, those beginning with 'base.' are removed.
#
# No csh -f flag so that we get safe-rm instead of rm, where appropriate.

set extensions="{dvi,aux,log,toc,lof,bbl,blg,lot,inx}"

if ($#argv == 0) then
	   rm -f -R ./*.$extensions
else
	   foreach i ($*)
	   	   rm -f $i.tex~ $i.$extensions
	   end
endif
