MQElasso <- function(X, Y, Small, a) {
   # require pre-installation of package "lars"
   # X: NxP data matrix
   # Y: Nx1 data vector
   # Small: a small number controls the covergence in iterations 
   # a: between 0 and 1: |beta| \le a*|beta_lse|

call <- match.call()
N=length(Y); P=dim(X)[2]
Y<- Y-mean(Y)
for(i in 1:P) X[,i] <- X[,i]-mean(X[,i])
X <- as.matrix(X)

# Part I: calculate LSE with or without Lasso
t<- lars(X, Y, type="lasso", normalize=F, intercept=F)
M=dim(t$beta)[1]
UpBound <- a*sum(abs(t$beta[M,]))  # t$beta[M,]: ordinary LSE for \beta
i <- M-1
while(sum(abs(t$beta[i,]))>UpBound) i=i-1
Beta=t$beta[i,]  # lasso LSE for \beta
Yhat=0
for(j in 1:P) Yhat=Yhat+X[,j]*Beta[j]
YlseLasso=list(beta=Beta, fitted=Yhat, Cor=cor(Y,Yhat), R2reg=t$R2[i]) 
Yhat=0
for(j in 1:P) Yhat=Yhat+X[,j]*t$beta[M,j] # use the ordinary LSE to rank X
Ylse=list(beta=t$beta[M,], fitted=Yhat, Cor=cor(Y,Yhat), R2reg=t$R2[M])

# Part II: calculate (unconstrained) MQE,
Y1<-sort(Y)
Ysort <- sort.int(Yhat, index.return=T)
rMSE=sqrt(mean((Y1-Ysort$x)**2))
Diff=999999
X2=X
NoI=0
R = vector()
while(Diff>Small) {  rMSE0=rMSE; NoI=NoI+1
  X1 = X2[Ysort$ix,]
  X2=X1
  Ymqe <- lm(Y1~X1-1)
  Ysort <- sort.int(Ymqe$fitted, index.return=T)
  rMSE=sqrt(mean((Y1-Ysort$x)**2))
  R[NoI]=rMSE
  Diff=abs(rMSE-rMSE0)
}
Yhat=Ymqe$coefficients[1]*X[,1]
for(i in 2:P) Yhat=Yhat+Ymqe$coefficients[i]*X[,i]
UpBound <- a*sum(abs(Ymqe$coefficients)) # set upBound according to the unconstrained MQE
Ymqe=list(beta=Ymqe$coefficients, fitted=Yhat, Cor=cor(Y, Yhat), No.Iteration=NoI, rMSE=R)

# Part III: lasso MQE
Ysort <- sort.int(Yhat, index.return=T)
rMSE=sqrt(mean((Y1-Ysort$x)**2))
Diff=999999
X2=X
NoI=0
R = vector()
while(Diff>Small) {  rMSE0=rMSE; NoI=NoI+1
  X1 = X2[Ysort$ix,]
  X2=X1
  t<- lars(X1, Y1, type="lasso", normalize=F, intercept=F)
  M=dim(t$beta)[1]
  i=M
  while(sum(abs(t$beta[i,]))>UpBound) i=i-1
  Beta=t$beta[i,]
  Yhat=0
  for(j in 1:P) Yhat=Yhat+X1[,j]*Beta[j]
  Ysort <- sort.int(Yhat, index.return=T)
  rMSE=sqrt(mean((Y1-Ysort$x)**2))
  R[NoI]=rMSE
  Diff=abs(rMSE-rMSE0)
} 
Yhat=Beta[1]*X[,1]
for(i in 2:P) Yhat=Yhat+Beta[i]*X[,i]
YmqeLasso=list(beta=Beta, fitted=Yhat, Cor=cor(Yhat, Y), No.Iteration=NoI, rMSE=R)
output=list(call=call, Lse=Ylse, LseLasso=YlseLasso, Mqe=Ymqe, MqeLasso=YmqeLasso)
}

