MQElp <- function(X, Y, Small, a, alpha0, alpha1) {
# Calculate (i) ordinary LSE and MQE  Y~X'\beta
#            (ii) Lasso LSE for \beta,
#           (iii) Lasso MQE for \beta, and
#           (iv) Lasso partial MQE using the quantiles between alpha0 and alpha1 only
# For (iv), the maximum no. of iterations is set at K(=300)
# When alpha0=0 & alpha1=1, (iv) is omitted
#
# Pre-installed package: lars
#
   # X: NxP data matrix
   # Y: Nx1 data vector
   # Small: a small number controls the covergence in iterations 
   # a: between 0 and 1 such that |beta| <= a*|beta_lse|
   # 0<= alpha0 < alpha1 <=1: match the quantiles between alpha0 and alpha1 only
call <- match.call()
library(lars)
N=length(Y); P=dim(X)[2]; K=900
Y <- Y-mean(Y)
for(i in 1:P) X[,i] <- X[,i]-mean(X[,i])
X <- as.matrix(X)

# Part I: calculate LSE with or without Lasso
t <- lars(X, Y, type="lasso", normalize=F, intercept=F)
M=dim(t$beta)[1]
UpBound <- a*sum(abs(t$beta[M,])) # t$beta[M,]: ordinary LSE for \beta
i <- M-1
while(sum(abs(t$beta[i,]))>UpBound) i=i-1
Beta=t$beta[i,] # lasso estimate for \beta with L1 norm <= a*|ordinary LSE|
Yhat=0
for(j in 1:P) Yhat=Yhat+X[,j]*Beta[j]
YlseLasso=list(beta=Beta, fitted=Yhat, Cor=cor(Y,Yhat), R2reg=t$R2[i]) 
Yhat=0
for(j in 1:P) Yhat=Yhat+X[,j]*t$beta[M,j] # use the ordinary LSE to rank X
Ylse=list(beta=t$beta[M,], fitted=Yhat, Cor=cor(Y,Yhat), R2reg=t$R2[M])

# Part II: calculate  MQE (without lasso)
Y1<-sort(Y)
Ysort <- sort.int(Yhat, index.return=T)
rMSE=sqrt(mean((Y1-Ysort$x)**2))
Diff=999999
X2=X
NoI=0
R = vector()
while(Diff>Small) {  rMSE0=rMSE; NoI=NoI+1
  X1 = X2[Ysort$ix,]
  X2=X1
  Ymqe <- lm(Y1~X1-1)
  Ysort <- sort.int(Ymqe$fitted, index.return=T)
  rMSE=sqrt(mean((Y1-Ysort$x)**2))
  R[NoI]=rMSE
  Diff=abs(rMSE-rMSE0)
}
Yhat=Ymqe$coefficients[1]*X[,1]
for(i in 2:P) Yhat=Yhat+Ymqe$coefficients[i]*X[,i]
UpBound <- a*sum(abs(Ymqe$coefficients)) # set upBound according to the unconstrained MQE
Ymqe=list(beta=Ymqe$coefficients, fitted=Yhat, Cor=cor(Y, Yhat), No.Iteration=NoI, rMSE=R)

# Part III: lasso MQE
Ysort <- sort.int(Yhat, index.return=T)
rMSE=sqrt(mean((Y1-Ysort$x)^2))
Diff=999999
X2=X
NoI=0
R = vector()
while(Diff>Small) {  rMSE0=rMSE; NoI=NoI+1
  X1 = X2[Ysort$ix,]
  X2=X1
  t<- lars(X1, Y1, type="lasso", normalize=F, intercept=F)
  M=dim(t$beta)[1]
  i=M
  while(sum(abs(t$beta[i,]))>UpBound) i=i-1
  Beta=t$beta[i,]
  Yhat=0
  for(j in 1:P) Yhat=Yhat+X1[,j]*Beta[j]
  Ysort <- sort.int(Yhat, index.return=T)
  rMSE=sqrt(mean((Y1-Ysort$x)**2))
  R[NoI]=rMSE
  Diff=abs(rMSE-rMSE0)
} 
Yhat=Beta[1]*X[,1]
for(i in 2:P) Yhat=Yhat+Beta[i]*X[,i]
YmqeLasso=list(beta=Beta, fitted=Yhat, Cor=cor(Yhat, Y),
No.Iterations=NoI, rMSE=R)

# Part IV: lasso MQE matching quantiles between alpha0 & alpha1
if((alpha0==0)&(alpha1==1)) list(call=call, Lse=Ylse, LseLasso=YlseLasso, Mqe=Ymqe, MqeLasso=YmqeLasso) 
else {
Diff=999999; NoI=0
N1=as.integer(N*alpha0)+1; N2=as.integer(N*alpha1)
Y11=Y1[N1:N2]
X2=X
R <- vector()
while((Diff>Small)&(NoI<K)) { rMSE0=rMSE; NoI=NoI+1
	X1 = X2[Ysort$ix,]
	X2=X1
	X11=X1[N1:N2,]
	t<- lars(X11, Y11, type="lasso", normalize=F, intercept=F)
	M=dim(t$beta)[1]
	i=M
	while(sum(abs(t$beta[i,]))>UpBound) i=i-1
	Beta=t$beta[i,]
	Yhat=0
	for(j in 1:P) Yhat=Yhat+X1[,j]*Beta[j]
	Ysort <- sort.int(Yhat, index.return=T)
	rMSE=sqrt(mean((Y11-Ysort$x[N1:N2])**2))
	R[NoI]=rMSE
	Diff=abs(rMSE-rMSE0)
}
Yhat=Beta[1]*X[,1]
for(i in 2:P) Yhat=Yhat+Beta[i]*X[,i]
Ypart=list(beta=Beta, fitted=Yhat, Cor=cor(Yhat, Y), No.Iterations=NoI, rMSE=R)
list(call=call, Lse=Ylse, LseLasso=YlseLasso, Mqe=Ymqe, MqeLasso=YmqeLasso, MqePart=Ypart)
}
}
