*************************************************************
*Practical 3: Two-state duration model
*Transitions between employment and non-employment
*************************************************************

set mem 150m
set more off

use bhps, clear 
sort pid spell t

* Create dummy variables for all categorical variables (taking 1st category as reference in each case)

local i = 2
while `i' <=10 {
  gen tgp`i' = tgp==`i'
  local i = `i' + 1
}
local i = 2
while `i' <=8 {
  gen age`i' = ageg8==`i'
  local i = `i' + 1
}
 

*Create dummies for employment and non-employment states
*Create response index (1=non-employment, 2=employment)
gen r1 = employ==0
gen r2 = employ==1
gen r=employ+1

gen r1_t2=r1*tgp2
gen r1_t3=r1*tgp3
gen r1_t4=r1*tgp4
gen r1_t5=r1*tgp5
gen r1_t6=r1*tgp6
gen r1_t7=r1*tgp7
gen r1_t8=r1*tgp8
gen r1_t9=r1*tgp9
gen r1_t10=r1*tgp10
gen r1_age2=r1*age2
gen r1_age3=r1*age3
gen r1_age4=r1*age4
gen r1_age5=r1*age5
gen r1_age6=r1*age6
gen r1_age7=r1*age7
gen r1_age8=r1*age8
gen r1_ejob=r1*everjob

gen r2_t2=r2*tgp2
gen r2_t3=r2*tgp3
gen r2_t4=r2*tgp4
gen r2_t5=r2*tgp5
gen r2_t6=r2*tgp6
gen r2_t7=r2*tgp7
gen r2_t8=r2*tgp8
gen r2_t9=r2*tgp9
gen r2_t10=r2*tgp10
gen r2_age2=r2*age2
gen r2_age3=r2*age3
gen r2_age4=r2*age4
gen r2_age5=r2*age5
gen r2_age6=r2*age6
gen r2_age7=r2*age7
gen r2_age8=r2*age8

compress

***XTMELOGIT

log using "prac3_xtmelogit.log.txt", replace text

xtmelogit event ///
r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 r1_ejob ///
r2 r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
, nocons ///
|| pid: r1 r2, nocons cov(unstructured)

estimates save two_state_xtmelogit, replace

log close
