*****************************************************************
*Practical 4 Exercise:
*Competing risks model
*Transitions from non-employment to full-time and part-time work
*****************************************************************

set mem 150m
set more off

use bhps, clear 
sort pid spell t

* Select non-employment spells
keep if employ==0

* Create dummy variables for all categorical variables (taking 1st category as reference in each case)

local i = 2
while `i' <=10 {
  gen tgp`i' = tgp==`i'
  local i = `i' + 1
}
local i = 2
while `i' <=8 {
  gen age`i' = ageg8==`i'
  local i = `i' + 1
}
local i = 2
while `i' <=3 {
  gen mstat`i' = marstat==`i'
  local i = `i' + 1
} 
local i = 1
while `i' <=2 {
  gen nkidy`i' = nchildy==`i'
  local i = `i' + 1
} 
local i = 1
while `i' <=2 {
  gen nkido`i' = nchildo==`i'
  local i = `i' + 1
} 

* Create bivariate data structure for MLwiN
expand 2
sort pid spell t
egen r=seq(), from(1) to(2) block(1)

gen y=0
replace y=1 if r==1 & event2==1
replace y=1 if r==2 & event2==2

*Create dummies for response types
gen r1 = r==1
gen r2 = r==2

gen r1_t2=r1*tgp2
gen r1_t3=r1*tgp3
gen r1_t4=r1*tgp4
gen r1_t5=r1*tgp5
gen r1_t6=r1*tgp6
gen r1_t7=r1*tgp7
gen r1_t8=r1*tgp8
gen r1_t9=r1*tgp9
gen r1_t10=r1*tgp10
gen r1_age2=r1*age2
gen r1_age3=r1*age3
gen r1_age4=r1*age4
gen r1_age5=r1*age5
gen r1_age6=r1*age6
gen r1_age7=r1*age7
gen r1_age8=r1*age8
gen r1_mstat2=r1*mstat2
gen r1_mstat3=r1*mstat3
gen r1_bir=r1*birth
gen r1_nkidy1=r1*nkidy1
gen r1_nkidy2=r1*nkidy2
gen r1_nkido1=r1*nkido1
gen r1_nkido2=r1*nkido2
gen r1_ejob=r1*everjob
gen r1_lpt=r1*lptime
gen r1_ljclass2=r1*ljobclass2
gen r1_ljclass3=r1*ljobclass3

gen r2_t2=r2*tgp2
gen r2_t3=r2*tgp3
gen r2_t4=r2*tgp4
gen r2_t5=r2*tgp5
gen r2_t6=r2*tgp6
gen r2_t7=r2*tgp7
gen r2_t8=r2*tgp8
gen r2_t9=r2*tgp9
gen r2_t10=r2*tgp10
gen r2_age2=r2*age2
gen r2_age3=r2*age3
gen r2_age4=r2*age4
gen r2_age5=r2*age5
gen r2_age6=r2*age6
gen r2_age7=r2*age7
gen r2_age8=r2*age8
gen r2_mstat2=r2*mstat2
gen r2_mstat3=r2*mstat3
gen r2_bir=r2*birth
gen r2_nkidy1=r2*nkidy1
gen r2_nkidy2=r2*nkidy2
gen r2_nkido1=r2*nkido1
gen r2_nkido2=r2*nkido2
gen r2_ejob=r2*everjob
gen r2_lpt=r2*lptime
gen r2_ljclass2=r2*ljobclass2
gen r2_ljclass3=r2*ljobclass3

compress

sabre, data pid r r1 r2 y ///
   r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 ///
   r1_mstat2 r1_mstat3 r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
   r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
   r2_mstat2 r2_mstat3 r2_bir r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2
sabre pid r r1 r2 y ///
   r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 ///
   r1_mstat2 r1_mstat3 r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
   r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
   r2_mstat2 r2_mstat3 r2_bir r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2, read


log using "prac4_exercises.log.txt", replace text

sabre, yvar y
sabre, model b
sabre, case pid
sabre, family first=b second=b
sabre, link first=l second=l
sabre, rvar r
sabre, constant first=r1 second=r2

sabre, nvar 24

*Start by fitting a model with uncorrelated random effects

sabre, corr n
sabre, fit r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 ///
   r1_mstat2 r1_mstat3 r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2 r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
   r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
   r2_mstat2 r2_mstat3 r2_bir r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2
sabre, dis m
sabre, dis e

*Now allow the random effects to be correlated

sabre, corr y
sabre, fit r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 ///
   r1_mstat2 r1_mstat3 r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2 r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
   r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
   r2_mstat2 r2_mstat3 r2_bir r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2
sabre, dis m
sabre, dis e

log close



