*****************************************************************
*Practical 5 Exercise: 
*Multiprocess model (2 processes)
*Non-employment transitions and births
*****************************************************************

set more off

*************************************************************
*5.2 Multiprocess model for exits from employment and births
*************************************************************

use bhps, clear 
sort pid spell t

* Create dummy variables for all categorical variables (taking 1st category as reference in each case)

local i = 2
while `i' <=10 {
  gen tgp`i' = tgp==`i'
  local i = `i' + 1
}
local i = 2
while `i' <=8 {
  gen age`i' = ageg8==`i'
  local i = `i' + 1
}
local i = 2
while `i' <=3 {
  gen jobclass`i' = jobclass==`i'
  replace jobclass`i'=0 if jobclass`i'==.
  gen marstat`i' = marstat==`i'
  local i = `i' + 1
}
local i = 1
while `i' <=2 {
  gen nchildy`i' = nchildy==`i'
  gen nchildo`i' = nchildo==`i'
  local i = `i' + 1
}

save temp, replace

*create bivariate structure for exits from employment and births

*first select employment episodes and code r=1 for non-employment transitions
keep if employ==1
gen r=1
gen y=event

*now append records for non-employment and employment episodes as we want to model births during both
append using temp

replace r=2 if r==.
replace y=birth if r==2

sort pid t r

*Create dummies for employment and birth responses
*Create response index (1=non-employment, 2=birth)
gen r1 = r==1
gen r2 = r==2

gen r1_t2=r1*tgp2
gen r1_t3=r1*tgp3
gen r1_t4=r1*tgp4
gen r1_t5=r1*tgp5
gen r1_t6=r1*tgp6
gen r1_t7=r1*tgp7
gen r1_t8=r1*tgp8
gen r1_t9=r1*tgp9
gen r1_t10=r1*tgp10
gen r1_age2=r1*age2
gen r1_age3=r1*age3
gen r1_age4=r1*age4
gen r1_age5=r1*age5
gen r1_age6=r1*age6
gen r1_age7=r1*age7
gen r1_age8=r1*age8
gen r1_pt=r1*ptime
gen r1_jclass2=r1*jobclass2
gen r1_jclass3=r1*jobclass3
gen r1_mstat2=r1*marstat2
gen r1_mstat3=r1*marstat3
gen r1_bir=r1*birth
gen r1_nkidy1=r1*nchildy1
gen r1_nkidy2=r1*nchildy2
gen r1_nkido1=r1*nchildo1
gen r1_nkido2=r1*nchildo2

gen r2_age2=r2*age2
gen r2_age3=r2*age3
gen r2_age4=r2*age4
gen r2_age5=r2*age5
gen r2_age678=r2*(age6+age7+age8)
gen r2_emp=r2*employ
gen r2_pt=r2*ptime
gen r2_jc2=r2*jobclass2
gen r2_jc3=r2*jobclass3
gen r2_mst2=r2*marstat2
gen r2_mst3=r2*marstat3
gen r2_nkidy1=r2*nchildy1
gen r2_nkidy2=r2*nchildy2
gen r2_nkido1=r2*nchildo1
gen r2_nkido2=r2*nchildo2

compress

sabre, data pid r r1 r2 y ///
   r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8   ///
   r1_pt r1_jclass2 r1_jclass3 r1_mstat2 r1_mstat3 ///
   r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2_age2 r2_age3 r2_age4 r2_age5 r2_age678 ///
   r2_emp r2_pt r2_jc2 r2_jc3 r2_mst2 r2_mst3 ///
   r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2
sabre pid r r1 r2 y ///
   r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8  /// 
   r1_pt r1_jclass2 r1_jclass3 r1_mstat2 r1_mstat3 ///
   r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2_age2 r2_age3 r2_age4 r2_age5 r2_age678 ///
   r2_emp r2_pt r2_jc2 r2_jc3 r2_mst2 r2_mst3 ///
   r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2, read

log using "prac5_exercises.log.txt", replace text

sabre, yvar y
sabre, model b
sabre, case pid
sabre, family first=b second=b
sabre, link first=l second=l
sabre, rvar r
sabre, constant first=r1 second=r2
sabre, nvar 27

*Fit multiprocess model

sabre, fit r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8  /// 
   r1_pt r1_jclass2 r1_jclass3 r1_mstat2 r1_mstat3 ///
   r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2 r2_age2 r2_age3 r2_age4 r2_age5 r2_age678 ///
   r2_emp r2_pt r2_jc2 r2_jc3 r2_mst2 r2_mst3 ///
   r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2
sabre, dis m
sabre, dis e

*Fit zero-correlation model for comparison

sabre, corr n
sabre, fit r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8  /// 
   r1_pt r1_jclass2 r1_jclass3 r1_mstat2 r1_mstat3 ///
   r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2 r2_age2 r2_age3 r2_age4 r2_age5 r2_age678 ///
   r2_emp r2_pt r2_jc2 r2_jc3 r2_mst2 r2_mst3 ///
   r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2
sabre, dis m
sabre, dis e

log close

