*************************************************************
*Practical 3: Autoregressive model
*Employment status
*************************************************************

set mem 150m
set more off

use bhps, clear 
sort pid spell t

* Create dummy variables for age (taking 1st category as reference)

local i = 2
while `i' <=8 {
  gen age`i' = ageg8==`i'
  local i = `i' + 1
}
 
*Calculate lagged response
by pid: gen emplag=employ[_n-1]

list pid t employ emplag in 1/30 

*Calculate lagged covariates
by pid: gen ptlag=ptime[_n-1]
by pid: gen marstlag=marstat[_n-1]
tab marstlag, gen(marstlag)

log using prac3_ar1.log.txt, text replace

***********************************
*Model without initial condition
***********************************

xtset pid
xtlogit employ emplag age2-age8 marstlag2 marstlag3 ptlag, re  

*****************************************************************
*Initial conditions: Add equation for obs=1 
*where obs=1 for the first observation for each woman (NOT spell)
*****************************************************************

*Calculate dummies for obs=1 and obs>1
by pid: gen obs=_n
gen r1=(obs==1)
gen r2=1-r1
 
*Define covariates for obs=1 equation

local i = 2 
while `i'<=8 {
  gen r1_age`i'=r1*age`i'
  local i=`i'+1
}
gen r1_mst2=r1*(marstat==2)
gen r1_mst3=r1*(marstat==3)


*Define covariates for obs>1 equation

*Note that for lagged covariates this is equivalent to coding missing values at obs=1 to zero

local i = 2
while `i'<=8 {
  gen r2_age`i'=r2*age`i'
  local i=`i'+1
}

gen r2_mst2lag=marstlag2
replace r2_mst2lag=0 if r2_mst2lag==.
gen r2_mst3lag=r2*marstlag3
replace r2_mst3lag=0 if r2_mst3lag==.
gen r2_emplag=r2*emplag
replace r2_emplag=0 if r2_emplag==.
gen r2_ptlag=r2*ptlag
replace r2_ptlag=0 if r2_ptlag==.


*Fit common random effect for obs=1 and obs>1

xtlogit employ r1 r1_age2-r1_age8 r1_mst2 r1_mst3 ///
	r2 r2_emplag r2_age2-r2_age8 r2_mst2 r2_mst3 r2_ptlag, ///
	nocons re	

	
*Fit same model in Sabre 

gen r=obs
replace r=2 if obs>1
	
sabre, data pid r r1 r2 employ ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 r1_mst2 r1_mst3  /// 
   r2_emplag r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
   r2_mst2lag r2_mst3lag r2_ptlag
   
sabre pid r r1 r2 employ ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 r1_mst2 r1_mst3  /// 
   r2_emplag r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
   r2_mst2lag r2_mst3lag r2_ptlag, read

sabre, yvar employ
sabre, case pid
sabre, family b
sabre, link l

sabre, quadrature a
sabre, mass 12
sabre, fit r1 r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 ///
	r1_mst2 r1_mst3 ///
	r2 r2_emplag r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
	r2_mst2lag r2_mst3lag r2_ptlag

sabre, dis m
sabre, dis e


*Allow different random effect variances for obs=1 and obs>1 equations (in Sabre) 
sabre, rvar r
sabre, nvar 10
sabre, depend y

sabre, fit r1 r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 ///
	r1_mst2 r1_mst3 ///
	r2 r2_emplag r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
	r2_mst2lag r2_mst3lag r2_ptlag
	
sabre, dis m
sabre, dis e
	
log close
