*****************************************************************
*Practical 5: Multiprocess model (3 processes)
*Employment and non-employment transitions and births
*****************************************************************

set more off

*************************************************************
*Multiprocess model for exits from employment, non-employment and births
*************************************************************

use bhps, clear 
sort pid spell t

* Create dummy variables for all categorical variables (taking 1st category as reference in each case)

local i = 2
while `i' <=10 {
  gen tgp`i' = tgp==`i'
  local i = `i' + 1
}
local i = 2
while `i' <=8 {
  gen age`i' = ageg8==`i'
  local i = `i' + 1
}
local i = 2
while `i' <=3 {
  gen jobclass`i' = jobclass==`i'
  replace jobclass`i'=0 if jobclass`i'==.
  gen marstat`i' = marstat==`i'
  local i = `i' + 1
}
local i = 1
while `i' <=2 {
  gen nchildy`i' = nchildy==`i'
  gen nchildo`i' = nchildo==`i'
  local i = `i' + 1
}

save temp, replace

*Create trivariate structure for exits from non-employment, employment and births

*Step 1. First select non-employment episodes and code r=1 for employment transitions
keep if employ==0
gen r=1
gen y=event

save temp2, replace

*Step 2. Select employment episodes and code r=2 for non-employment transitions
use temp, clear

keep if employ==1
gen r=2
gen y=event

*Now append records for non-employment episodes selected in Step 1
append using temp2
save temp2, replace

*Step 3. Append records for non-employment and employment episodes as we want to model births during both
append using temp

replace r=3 if r==.
replace y=birth if r==3

sort pid t r

*Create dummies for employment, non-employment and birth responses
*Create response index (1=employment, 2=non-employment, 3=birth)
gen r1 = r==1
gen r2 = r==2
gen r3 = r==3

gen r1_t2=r1*tgp2
gen r1_t3=r1*tgp3
gen r1_t4=r1*tgp4
gen r1_t5=r1*tgp5
gen r1_t6=r1*tgp6
gen r1_t7=r1*tgp7
gen r1_t8=r1*tgp8
gen r1_t9=r1*tgp9
gen r1_t10=r1*tgp10
gen r1_age2=r1*age2
gen r1_age3=r1*age3
gen r1_age4=r1*age4
gen r1_age5=r1*age5
gen r1_age6=r1*age6
gen r1_age7=r1*age7
gen r1_age8=r1*age8
gen r1_ejob=r1*everjob
gen r1_lpt=r1*lptime
gen r1_ljclass2=r1*ljobclass2
gen r1_ljclass3=r1*ljobclass3
gen r1_mstat2=r1*marstat2
gen r1_mstat3=r1*marstat3
gen r1_bir=r1*birth
gen r1_nkidy1=r1*nchildy1
gen r1_nkidy2=r1*nchildy2
gen r1_nkido1=r1*nchildo1
gen r1_nkido2=r1*nchildo2

gen r2_t2=r2*tgp2
gen r2_t3=r2*tgp3
gen r2_t4=r2*tgp4
gen r2_t5=r2*tgp5
gen r2_t6=r2*tgp6
gen r2_t7=r2*tgp7
gen r2_t8=r2*tgp8
gen r2_t9=r2*tgp9
gen r2_t10=r2*tgp10
gen r2_age2=r2*age2
gen r2_age3=r2*age3
gen r2_age4=r2*age4
gen r2_age5=r2*age5
gen r2_age6=r2*age6
gen r2_age7=r2*age7
gen r2_age8=r2*age8
gen r2_pt=r2*ptime
gen r2_jclass2=r2*jobclass2
gen r2_jclass3=r2*jobclass3
gen r2_mstat2=r2*marstat2
gen r2_mstat3=r2*marstat3
gen r2_bir=r2*birth
gen r2_nkidy1=r2*nchildy1
gen r2_nkidy2=r2*nchildy2
gen r2_nkido1=r2*nchildo1
gen r2_nkido2=r2*nchildo2

gen r3_age2=r3*age2
gen r3_age3=r3*age3
gen r3_age4=r3*age4
gen r3_age5=r3*age5
gen r3_age678=r3*(age6+age7+age8)
gen r3_emp=r3*employ
gen r3_pt=r3*ptime
gen r3_jc2=r3*jobclass2
gen r3_jc3=r3*jobclass3
gen r3_mst2=r3*marstat2
gen r3_mst3=r3*marstat3
gen r3_nkidy1=r3*nchildy1
gen r3_nkidy2=r3*nchildy2
gen r3_nkido1=r3*nchildo1
gen r3_nkido2=r3*nchildo2

compress


***XTMELOGIT

log using "prac5_3process_xtmelogit.log.txt", replace text

xtmelogit y ///
   r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 r1_ejob  ///
   r1_lpt r1_ljclass2 r1_ljclass3 r1_mstat2 r1_mstat3 ///
   r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2 r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
   r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
   r2_pt r2_jclass2 r2_jclass3 r2_mstat2 r2_mstat3 ///
   r2_bir r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2 ///
   r3 r3_age2 r3_age3 r3_age4 r3_age5 r3_age678 ///
   r3_emp r3_pt r3_jc2 r3_jc3 r3_mst2 r3_mst3 ///
   r3_nkidy2 r3_nkido1 r3_nkido2 ///
   , nocons ///
   || pid: r1 r2 r3, nocons cov(unstructured)

*Fit zero-correlation model for comparison

xtmelogit y ///
   r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
   r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 r1_ejob  ///
   r1_lpt r1_ljclass2 r1_ljclass3 r1_mstat2 r1_mstat3 ///
   r1_bir r1_nkidy1 r1_nkidy2 r1_nkido1 r1_nkido2 ///
   r2 r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
   r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8 ///
   r2_pt r2_jclass2 r2_jclass3 r2_mstat2 r2_mstat3 ///
   r2_bir r2_nkidy1 r2_nkidy2 r2_nkido1 r2_nkido2 ///
   r3 r3_age2 r3_age3 r3_age4 r3_age5 r3_age678 ///
   r3_emp r3_pt r3_jc2 r3_jc3 r3_mst2 r3_mst3 ///
   r3_nkidy2 r3_nkido1 r3_nkido2 ///
   , nocons ///
   || pid: r1 r2 r3, nocons 

log close
