*************************************************************
*Practical 1: Discrete-Time Models of the Time to a Single Event
*************************************************************

set more off

use ncds, clear

*View the data

list in 1/20

*View the number of censored cases

tab event


*************************************************************
*2. Discrete-time logit models
*************************************************************

***Data preparation: the person-period file

*Calculate duration (in number of years from age 16 to 1st partnership from t=1)

gen dur=age1st-16+1

*Generate dur records for each individual

expand dur
sort id

*Create t and binary response for each year y
*y=1 for the last record for uncensored cases and y=0 otherwise

by id: gen t=_n
gen age=t+15
gen y=0
replace y=1 if (age==age1st & event==1)

list in 1/20, nol

*Create time-varying covariate fulltime

gen fulltime=1
replace fulltime=0 if age>ageleft


***Fitting age as a step function (with female and fulltime as covariates)

*Create age dummies

tab t, gen(t)

logit y t2-t18 female fulltime

*Calculate predicted probability of an event (discrete-time hazard)

predict haz, pr

*Plot hazard (for men when not in full-time education)

sort t
scatter haz t if (female==0 & fulltime==0)


***Fitting a quadratic in age (with female and fulltime as covariates)

gen tsq=t*t
logit y t tsq female fulltime

*Calculate predicted probability of an event (discrete-time hazard)

predict hazquad, pr

*Plot hazard (for men when not in full-time education)

sort t
scatter hazquad t if (female==0 & fulltime==0)


***Allowing for non-proportional effects of gender

gen t_fem=t*female
gen tsq_fem=tsq*female
logit y t tsq female t_fem tsq_fem fulltime

*Test for non-proportionality

test t_fem tsq_fem

*Calculate predicted probability of an event (discrete-time hazard)

predict hazint, pr

*Plot hazard by gender (when not in full-time education)

sort t
scatter hazint t if female==1 & fulltime==0, legend(label(1 "F")) || ///
  scatter hazint t if female==0 & fulltime==0, legend(label(2 "M"))


