*************************************************************
*Practical 1: Discrete-Time Models of the Time to a Single Event
*************************************************************

set more off

*Set path for MLwiN
global MLwiN_path C:\Program Files\MLwiN v2.25\MLwiN.exe

use ncds, clear

******************************************************************************
*Discrete-time logit models in runmlwin
*
*For full details of runmlwin (including installation and documentation) go to 
*http://www.bristol.ac.uk/cmm/software/runmlwin/
******************************************************************************

***Data preparation: the person-period file

*Calculate duration (in number of years from age 16 to 1st partnership from t=1)

gen dur=age1st-16+1

*Generate dur records for each individual

expand dur
sort id

*Create t and binary response for each year y
*y=1 for the last record for uncensored cases and y=0 otherwise

by id: gen t=_n
gen age=t+15
gen y=0
replace y=1 if (age==age1st & event==1)

*Create time-varying covariate fulltime

gen fulltime=1
replace fulltime=0 if age>ageleft

*Create age dummies and a quadratic term

tab t, gen(t)
gen tsq=t*t

*Interact continuous time variables with female

gen t_fem=t*female
gen tsq_fem=tsq*female

***RUNMLWIN

*Generate variables needed by MLwiN

*Constant variable (its coefficient will be the overall intercept)
gen cons=1
*Level 1 id for each observations (single level model)
gen l1id=_n

log using "prac1_mlwin.log.txt", replace text

***Fitting age as a step function (with female and fulltime as covariates)

*First fit model using MQL1 approximation (to get starting values for MCMC).  
*MQL1 is equivalent to maximum-likelihood for single-level models
*The denominator will always equal 1 for a binary response, so we specify the cons variable 
*created above. The 'nopause' option runs MLwiN in the background and brings results back into Stata.
*The 'pause' option can be used to go into MLwiN (having set up the model).  This is useful for checking the model setup.

runmlwin y ///
t2-t18 female fulltime cons, ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) maxi(50) nopause 

*Now estimate the model using MCMC. We specify a burn-in of 500 and chain length of 5000 (but in practice longer chains
*will be required).  The 'initsprevious' tells MLwiN to use estimates from the previous model as starting values. 
*The 'orth' option specifies the use of orthogonal fixed effects to improve efficiency of MCMC sampling.
*See Chapter 23 of the 'MCMC Estimation in MLwiN' User Guide at http://www.bristol.ac.uk/cmm/software/mlwin/download/manuals.html
*A random number seed is used to ensure we get the same results each time the model is re-run.

runmlwin y ///
t2-t18 female fulltime cons, ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) ///
mcmc(burnin(500) chain(5000) orth seed(1)) initsprevious nopause

***Fitting a quadratic in age (with female and fulltime as covariates)

*MQL1 estimates (to get starting values for MCMC)
runmlwin y ///
t tsq female fulltime cons, ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) maxi(50) nopause 

*MCMC (500 burn-in, 5000 samples) 
*Parameter expansion and orthogonal fixed effects 
runmlwin y ///
t tsq female fulltime cons, ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) ///
mcmc(burnin(500) chain(5000) orth seed(1)) initsprevious nopause

***Allowing for non-proportional effects of gender

*MQL1 estimates (to get starting values for MCMC)
runmlwin y ///
t tsq female t_fem tsq_fem fulltime cons, ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) maxi(50) nopause 

*MCMC (500 burn-in, 5000 samples) 
*Parameter expansion and orthogonal fixed effects 
runmlwin y ///
t tsq female t_fem tsq_fem fulltime cons, ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) ///
mcmc(burnin(500) chain(5000) orth seed(1)) initsprevious nopause


log close



