*****************************************************************
*Practical 4: Competing risks model
*Transitions from non-employment to full-time and part-time work
*****************************************************************

set mem 150m
set more off

*Set path for MLwiN
global MLwiN_path C:\Program Files\MLwiN v2.25\MLwiN.exe

******************************************************************************
*Competing risks model in runmlwin

*For full details of runmlwin (including installation and documentation) go to 
*http://www.bristol.ac.uk/cmm/software/runmlwin/
******************************************************************************

use bhps, clear 
sort pid spell t

* Select non-employment spells
keep if employ==0

* Create dummy variables for all categorical variables (taking 1st category as reference in each case)

local i = 2
while `i' <=10 {
  gen tgp`i' = tgp==`i'
  local i = `i' + 1
}
local i = 2
while `i' <=8 {
  gen age`i' = ageg8==`i'
  local i = `i' + 1
}

* Create bivariate data structure for Sabre
expand 2
sort pid spell t
egen r=seq(), from(1) to(2) block(1)

gen y=0
replace y=1 if r==1 & event2==1
replace y=1 if r==2 & event2==2

*Create dummies for response types
gen r1 = r==1
gen r2 = r==2

gen r1_t2=r1*tgp2
gen r1_t3=r1*tgp3
gen r1_t4=r1*tgp4
gen r1_t5=r1*tgp5
gen r1_t6=r1*tgp6
gen r1_t7=r1*tgp7
gen r1_t8=r1*tgp8
gen r1_t9=r1*tgp9
gen r1_t10=r1*tgp10
gen r1_age2=r1*age2
gen r1_age3=r1*age3
gen r1_age4=r1*age4
gen r1_age5=r1*age5
gen r1_age6=r1*age6
gen r1_age7=r1*age7
gen r1_age8=r1*age8

gen r2_t2=r2*tgp2
gen r2_t3=r2*tgp3
gen r2_t4=r2*tgp4
gen r2_t5=r2*tgp5
gen r2_t6=r2*tgp6
gen r2_t7=r2*tgp7
gen r2_t8=r2*tgp8
gen r2_t9=r2*tgp9
gen r2_t10=r2*tgp10
gen r2_age2=r2*age2
gen r2_age3=r2*age3
gen r2_age4=r2*age4
gen r2_age5=r2*age5
gen r2_age6=r2*age6
gen r2_age7=r2*age7
gen r2_age8=r2*age8

compress

***RUNMLWIN

log using "prac4_mlwin.log.txt", replace text

*Generate variables needed by MLwiN (see prac 2 for details)
gen cons=1
*Level 2 id with lower precision than pid
gen l2id=pid/1000
*Level 1 id for observations within person
sort pid
by pid: gen l1id=_n

*Start by fitting a model with uncorrelated random effects (diagonal option)

*MQL1 estimates (to get starting values for MCMC)
runmlwin y ///
r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8  ///
r2 r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8, ///
level2(l2id: r1 r2, diagonal) ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) maxi(50) nopause 

*MCMC (500 burn-in, 5000 samples) 
*Parameter expansion and orthogonal fixed effects 
runmlwin y ///
r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 ///
r2 r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8, ///
level2(l2id: r1 r2, diagonal parexpansion) ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) ///
mcmc(burnin(500) chain(5000) orth seed(1)) initsprevious nopause

*Now allow the random effects to be correlated 

*MQL1 estimates (to get starting values for MCMC)
runmlwin y ///
r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8  ///
r2 r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8, ///
level2(l2id: r1 r2) ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) maxi(50) nopause 

*MCMC (500 burn-in, 5000 samples) 
*Parameter expansion and orthogonal fixed effects 
runmlwin y ///
r1 r1_t2 r1_t3 r1_t4 r1_t5 r1_t6 r1_t7 r1_t8 r1_t9 r1_t10 ///
r1_age2 r1_age3 r1_age4 r1_age5 r1_age6 r1_age7 r1_age8 ///
r2 r2_t2 r2_t3 r2_t4 r2_t5 r2_t6 r2_t7 r2_t8 r2_t9 r2_t10 ///
r2_age2 r2_age3 r2_age4 r2_age5 r2_age6 r2_age7 r2_age8, ///
level2(l2id: r1 r2, parexpansion) ///
level1(l1id:) ///
discrete(distribution(binomial) link(logit) denom(cons)) ///
mcmc(burnin(500) chain(5000) orth seed(1)) initsprevious nopause

log close



